# Configures a bare metal package repo.
class twitch_package_repo {

  $base_dir = hiera('apt_mirror::base_path')
  require apt_mirror
  # Remove the default created by the twitch_package repo module, the new one is below. can be removed after Oct 7, 2017
  file {'/etc/cron.d/apt-mirror': ensure => absent }
  twitch_cron { 'apt-mirror-production':
    ensure  => present,
    command => '/usr/bin/apt-mirror /etc/apt/apt-mirror.production 2>&1 | logger -p local3.info -t apt_mirror',
    user    => 'apt-mirror',
    minute  => '0',
    hour    => '4',
  }

  realize(Twitch_nrdp::Check['check_sandstorm_agent','check_sandstorm_agent_ops'])

  twitch_sandstorm_agent::template { 'apt-mirror.production':
    destination => '/etc/apt/apt-mirror.production',
    source      => '/etc/apt/mirror.list',
  }

  twitch_nginx::vhost { 'package_repo':
    content => template("${module_name}/nginx.conf.erb"),
  }

  file { "$base_dir/var/postmirror.sh":
    content => template("${module_name}/postmirror.sh.erb"),
    mode    => '0755',
  }

  file { "$base_dir/var/clean.sh":
    content => template("${module_name}/clean.sh.erb"),
    mode    => '0755',
  }

}
