module Puppet::Parser::Functions
    newfunction(:host_array_to_hash, :type => :rvalue, :doc => <<-'ENDHEREDOC') do |args|
    Builds a hash from an array of host names.  The hash is of the form:
    
        {
            "${prefix}${index+1}": {
                'hostname': "${value}"
            }
        }

    For example:

        $hash1 = ['google.com', 'technicpack.net']
        $hash2 = host_array_to_hash($hash1,'prefix_')
        # The resulting hash is equivalent to:
        # $hash2 =  {'prefix_1': {'hostname': 'google.com'}, 'prefix_2': {'hostname': 'technicpack.net'}}

    ENDHEREDOC

    if args.length != 2
        raise Puppet::ParseError, ("host_array_to_hash(): wrong number of args (#{args.length}; must be at least 2)")
    end

    original = args[0]
    unless original.is_a?(Array)
        raise(Puppet::ParseError, 'host_array_to_hash(): first arg must be an array')
    end

    prefix = args[1]
    unless prefix.is_a?(String)
        raise(Puppet::ParseError, 'host_array_to_hash(): second arg must be a string')
    end

    # The destination hash we'll be filling.
    retVal = Hash.new

    original.each_with_index do |host, index|
        newKey = "#{prefix}#{index+1}"
        retVal[newKey] = {"hostname" => host}
    end

    # Return the new hash
    retVal
    end
end
