class twitch_pgbouncer::config inherits twitch_pgbouncer {
  # this is so we can have multiple init scripts side by side,
  # named after the service behind it, in the case of multiple
  # pgbouncers per box which is handled by twitch_pgbouncer::instance
  service { 'pgbouncer':
    ensure => 'stopped',
    enable => false
  }

  file { [
    "${twitch_pgbouncer::config_dir}/pgbouncer.ini",
    "${twitch_pgbouncer::config_dir}/userlist.txt",
  ]:
    ensure  => 'absent',
    require => Service['pgbouncer']
  }

  file { $twitch_pgbouncer::config_dir:
    ensure => 'directory',
    mode   => '0640',
    owner  => $twitch_pgbouncer::user,
    group  => $twitch_pgbouncer::group,
  }
  # This is a template unit file that can be used to spawn many processes.
  twitch_systemd::unit_file { 'pgbouncer@.service':
    content => template('twitch_pgbouncer/pgbouncer-template.service.erb'),
  }
}
