class twitch_pgbouncer (
  $ensure = $twitch_pgbouncer::params::ensure,
  $users = $twitch_pgbouncer::params::users,
  $ss_team = $twitch_pgbouncer::params::ss_team,
  $fd_limit = $twitch_pgbouncer::params::fd_limit,
) inherits twitch_pgbouncer::params {

  validate_hash($users)

  # wrapper module contains repo and global postgresql configs
  require twitch_postgresql

  package { $package:
    ensure => $ensure
  }
  if $ensure != 'latest' {
    apt::pin { "pin-${package}":
      ensure   => 'present',
      packages => $package,
      version  => $ensure,
      priority => 1000,
    }
  }

  anchor { 'twitch_pgbouncer::start': } ->
  Package[$package] ->
  class { 'twitch_pgbouncer::config': } ->
  Twitch_pgbouncer::Instance <| |> ->
  anchor { 'twitch_pgbouncer::end': }
}
