class twitch_pgbouncer::instance::groupchat(  
  $master_host = '127.0.0.1',
  $database_name = 'chat_depot',
  $database_env = pick($::twitch_environment, 'production'),
) inherits twitch_pgbouncer {

  $userlist = {
    'depot_01' => '',
    'depot_02' => '',
  }

  # if no master_host, deploy local pgbouncer. otherwise use in proxy manner

  $databases = {
    "$database_name" => {
      'dbname' => $database_name,
      'host'   => $master_host,
      'port'   => '5432',
    }
  }
  $options = {
    'autodb_idle_timeout'    => '10',
    'log_connections'        => '0',
    'log_disconnections'     => '0',
    'server_connect_timeout' => '3',
    'server_idle_timeout'    => '10',
    'server_lifetime'        => '300',
    'server_login_retry'     => '1',
  }

  class { 'twitch_postgresql::lib::healthcheck':
    database_name => $database_name,
    ports         => ['6543', '6544'],
    user          => 'healthcheck',
  }

  class { 'watcher::pgbouncer_stats':
    ports => ['6543', '6544'],
  }

  twitch_pgbouncer::instance { 'groupchat':
    admin_users               => ['depot', 'nagios', 'pgbouncer'],
    default_pool_size         => '100',
    databases                 => $databases,
    listen_port               => '6543',
    options                   => $options,
    userlist                  => $userlist,
    database_name             => $database_name,
    database_env              => $database_env,
  }
  twitch_pgbouncer::instance { 'groupchat_session':
    admin_users               => ['depot', 'nagios', 'pgbouncer'],
    default_pool_size         => '25',
    databases                 => $databases,
    listen_port               => '6544',
    options                   => $options,
    pool_mode                 => 'session',
    userlist                  => $userlist,
    database_name             => $database_name,
    database_env              => $database_env,
  }
}
