class twitch_pgbouncer::instance::proxy (
  $database_name,
  $enable = true,
  $master_host,
  $revenue_pool_size,
  $subs_pool_size,
  $users_pool_size,
  $healthcheck_ports = ['6542', '6543', '12005'],
  $healthcheck_cluster = 'rails-postgres',
  $healthcheck_absolute_threshold = undef,
  $healthcheck_relative_threshold = undef,
) inherits twitch_pgbouncer {

  include twitch::haproxy::backend

  $userlist = {
    'revenue_01'            => '',
    'revenue_02'            => '',
    'subs_01'               => '',
    'subs_02'               => '',
    'users_service_01'      => '',
    'users_service_02'      => '',
  }
  $admin_users = ['nagios', 'pgbouncer']

  $prod = {
    'host'   => $master_host,
    'port'   => '5432',
    'dbname' => $database_name,
  }
  $transaction_databases = {
    "${database_name}" => merge({
      'pool_size' => '3',
    }, $prod),
    "revenue_${database_name}" => merge({
      'pool_size' => $revenue_pool_size,
    }, $prod),
    "subs_${database_name}" => merge({
      'pool_size' => $subs_pool_size,
    }, $prod),
    "users_service_${database_name}" => merge({
      'pool_size' => $users_pool_size,
    }, $prod),
  }
  $options = {
    'autodb_idle_timeout' => '10',
    'log_connections' => '0',
    'log_disconnections' => '0',
    'query_wait_timeout' => '2',
    'server_connect_timeout' => '3',
    'server_idle_timeout' => '10',
    'server_lifetime' => '300',
    'server_login_retry' => '1',
  }

  $deploy_env = pick($::twitch_environment, 'production')

  class { 'twitch_postgresql::lib::healthcheck':
    database_name      => $database_name,
    ports              => $healthcheck_ports,
    user               => 'healthcheck',
    cluster            => $healthcheck_cluster,
    deploy_env         => $deploy_env,
    absolute_threshold => $healthcheck_absolute_threshold,
    relative_threshold => $healthcheck_relative_threshold,
  }

  class { 'watcher::pgbouncer_stats':
    ports => ['6542', '6543'],
  }

  # We have a default_pool_size of 50 for 2 hosts running 2 proxies
  # each for a total of 200 postgresql backends.
  twitch_pgbouncer::instance { 'proxy1':
    listen_port       => '6542',
    default_pool_size => '33',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $transaction_databases,
    enable            => $enable,
    options           => $options,
    database_name     => $database_name,
    database_env      => $deploy_env,
  }

  twitch_pgbouncer::instance { 'proxy2':
    listen_port       => '6543',
    default_pool_size => '33',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $transaction_databases,
    enable            => $enable,
    options           => $options,
    database_name     => $database_name,
    database_env      => $deploy_env,
  }

}
