class twitch_pgbouncer::instance::proxy_dev (
  $healthcheck_ports = ['6542', '6543'],
  $remote_host,
  $revenue_pool_size,
  $subs_pool_size,
  $users_pool_size,
) inherits twitch_pgbouncer {
  $userlist = {
    'revenue_01'            => '',
    'revenue_02'            => '',
    'subs_01'               => '',
    'subs_02'               => '',
    'users_service_01'      => '',
    'users_service_02'      => '',
  }
  $admin_users = ['nagios', 'pgbouncer']

  $dev = {
    'dbname' => 'justintv_dev',
    'port'   => '5432',
  }
  $dev_local = merge({
    'host' => '127.0.0.1',
  }, $dev)
  $dev_remote = merge({
    'host' => $remote_host,
  }, $dev)

  $trx_databases_local = {
    'justintv_dev' => merge({
      'pool_size' => '3',
    }, $dev_local),
    'revenue_justintv_dev' => merge({
      'pool_size' => $revenue_pool_size,
    }, $dev_local),
    'subs_justintv_dev' => merge({
      'pool_size' => $subs_pool_size,
    }, $dev_local),
    'users_service_justintv_dev' => merge({
      'pool_size' => $users_pool_size,
    }, $dev_local),
  }

  $trx_databases_remote = {
    'justintv_dev' => merge({
      'pool_size' => '3',
    }, $dev_remote),
    'revenue_justintv_dev' => merge({
      'pool_size' => $revenue_pool_size,
    }, $dev_remote),
    'subs_justintv_dev' => merge({
      'pool_size' => $subs_pool_size,
    }, $dev_remote),
    'users_service_justintv_dev' => merge({
      'pool_size' => $users_pool_size,
    }, $dev_remote),
  }

  $options = {
    'autodb_idle_timeout' => '10',
    'log_connections' => '0',
    'log_disconnections' => '0',
    'query_wait_timeout' => '10',
    'server_connect_timeout' => '3',
    'server_idle_timeout' => '10',
    'server_lifetime' => '300',
    'server_login_retry' => '1',
  }
  $config_dir = $twitch_pgbouncer::config_dir

  class { 'twitch_postgresql::lib::healthcheck':
    database_name => 'justintv_dev',
    ports         => $healthcheck_ports,
    user          => 'healthcheck',
    cluster       => 'rails-postgres',
    deploy_env    => 'staging',
  }

  class { 'watcher::pgbouncer_stats':
    ports => ['6542', '6543'],
  }

  # We have a default_pool_size of 50 for 2 hosts, the local and
  # remote poxy_dev, running 2 proxies each for a total of 200
  # postgresql backends.
  twitch_pgbouncer::instance { 'proxy1_local':
    listen_port       => '6542',
    default_pool_size => '50',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $trx_databases_local,
    options           => $options,
    manage_service    => false,
    database_name     => 'justintv_dev',
    database_env      => 'staging',
  }

  twitch_pgbouncer::instance { 'proxy1_remote':
    listen_port       => '6542',
    default_pool_size => '50',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $trx_databases_remote,
    options           => $options,
    manage_service    => false,
    database_name     => 'justintv_dev',
    database_env      => 'staging',
  }

  $symlink_directory = '/etc/pgbouncer/init.d'
  file { $symlink_directory:
    ensure => absent,
  #  mode    => '0664', # -rw-rw-r--
  #  owner   => $user,
  #  group   => $group,
  #  require => User['postgres'],
  }
  # This file needs to exist, but the target of the symlink will
  # be managed outside of puppet
  file { '/etc/pgbouncer/init.d/proxy1':
    ensure  => absent,
  #  owner   => $user,
  #  group   => $group,
  #  target  => '/etc/init.d/pgbouncer_proxy1_local',
  #  replace => false,
  #  require => [ Twitch_pgbouncer::Instance['proxy1_local'], File[$symlink_directory] ],
  }

  twitch_pgbouncer::instance { 'proxy2_local':
    listen_port       => '6543',
    default_pool_size => '50',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $trx_databases_local,
    options           => $options,
    manage_service    => false,
    database_name     => 'justintv_dev',
    database_env      => 'staging',
  }

  twitch_pgbouncer::instance { 'proxy2_remote':
    listen_port       => '6543',
    default_pool_size => '50',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $trx_databases_remote,
    options           => $options,
    manage_service    => false,
    database_name     => 'justintv_dev',
    database_env      => 'staging',
  }

  file { '/etc/pgbouncer/init.d/proxy2':
    ensure  => absent,
  #  owner   => $user,
  #  group   => $group,
  #  target  => '/etc/init.d/pgbouncer_proxy2_local',
  #  replace => false,
  #  require => [ Twitch_pgbouncer::Instance['proxy2_local'], File[$symlink_directory] ],
  }

}
