class twitch_pgbouncer::instance::reports(
) inherits twitch_pgbouncer {
  $userlist = {
    'reports_01' => '',
  }
  $admin_users = ['nagios', 'pgbouncer']
  $databases = {
    'reports' => {
      'host'   => '127.0.0.1',
      'port'   => '5432',
      'dbname' => 'reports',
    }
  }
  $options = {
    'autodb_idle_timeout' => '10',
    'log_connections' => '0',
    'log_disconnections' => '0',
    'server_connect_timeout' => '3',
    'server_idle_timeout' => '10',
    'server_lifetime' => '300',
    'server_login_retry' => '1',
  }

  class { 'watcher::pgbouncer_stats':
    ports => ['6543'],
  }

  twitch_pgbouncer::instance { 'reports':
    listen_port               => '6543',
    default_pool_size         => '50',
    userlist                  => $userlist,
    admin_users               => $admin_users,
    databases                 => $databases,
    options                   => $options,
  }

}
