class twitch_pgbouncer::instance::site(
  $database_name,
  $enable = true,
  $query_wait_timeout = 2,
  $replay_target = false,
  $reports_pool_size = 0,
  $revenue_pool_size,
  $subs_pool_size,
  $users_pool_size,
) inherits twitch_pgbouncer {

  include twitch::haproxy::backend
  include twitch::haproxy::listeners::backend_database_sitedb_production_slave

  $userlist = {
    'revenue_01'            => '',
    'revenue_02'            => '',
    'subs_01'               => '',
    'subs_02'               => '',
    'users_service_01'      => '',
    'users_service_02'      => '',
  }
  $admin_users = ['nagios','pgbouncer']
  $common = {
    'host'     => '127.0.0.1',
    'port'     => '5432',
  }

  $prod = merge({
    'dbname' => $database_name,
  }, $common)
  $transaction_databases = {
    "${database_name}" => merge({
      'pool_size' => '3',
    }, $prod),
    "reports_${database_name}" => merge({
      'pool_size' => $reports_pool_size,
    }, $prod),
    "revenue_${database_name}" => merge({
      'pool_size' => $revenue_pool_size,
    }, $prod),
    "subs_${database_name}" => merge({
      'pool_size' => $subs_pool_size,
    }, $prod),
    "users_service_${database_name}" => merge({
      'pool_size' => $users_pool_size,
    }, $prod),
  }

  # In the unusual case that the database is being used for replays,
  # we do not need to send server reset or server checks since those
  # will already be in the logs. We also want easier stat inspection.
  $defaults = {}
  $replay_options = {
    'server_reset_query' => '',
    'server_check_query' => '',
    'stats_user' => 'rails',
  }
  $opts = $replay_target ? {
    true  => $replay_options,
    false => $defaults,
  }
  $options = merge({
    'autodb_idle_timeout' => '10',
    'log_connections' => '0',
    'log_disconnections' => '0',
    'query_wait_timeout' => "${query_wait_timeout}",
    'server_connect_timeout' => '3',
    'server_idle_timeout' => '10',
    'server_lifetime' => '300',
    'server_login_retry' => '1',
  }, $opts)

  $deploy_env = pick($::twitch_environment, 'production')

  class { 'twitch_postgresql::lib::healthcheck':
    database_name => $database_name,
    ports         => ['6542', '6543', '12006'],
    user          => 'healthcheck',
    cluster       => 'rails-postgres',
    deploy_env    => $deploy_env,
  }

  class { 'watcher::pgbouncer_stats':
    ports => ['6542', '6543'],
  }

  twitch_pgbouncer::instance { 'transaction1':
    listen_port       => '6542',
    default_pool_size => '50',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $transaction_databases,
    enable            => $enable,
    options           => $options,
    database_name     => $database_name,
    database_env      => $deploy_env,
  }

  twitch_pgbouncer::instance { 'transaction2':
    listen_port       => '6543',
    default_pool_size => '50',
    userlist          => $userlist,
    admin_users       => $admin_users,
    databases         => $transaction_databases,
    enable            => $enable,
    options           => $options,
    database_name     => $database_name,
    database_env      => $deploy_env,
  }

}
