# usher-postgres pgbouncer instance
class twitch_pgbouncer::instance::usher(
  $database_env      = pick($::twitch_environment, $twitch_environment, 'production'),
  $database_name     = 'usher',
  $default_pool_size = '24',
  $hotspares         = undef,
  $listen_port       = '6543',
  $master_host       = undef,
) inherits twitch_pgbouncer {
  $userlist = {
    'usher'              => '',
    'usher_readonly'     => '',
    'usher_readonly_01'  => '',
    'usher_readonly_02'  => '',
    'usher_readwrite'    => '',
    'usher_readwrite_01' => '',
    'usher_readwrite_02' => '',
  }
  $admin_users = ['usher', 'nagios', 'pgbouncer']

  # if no master_host, deploy local pgbouncer. otherwise use in proxy manner
  if $master_host == undef {
    $pgbouncer_host = '127.0.0.1'
  } else {
    $pgbouncer_host = $master_host
  }

  $databases = {
    "$database_name" => {
      'host'   => $pgbouncer_host,
      'port'   => '5432',
      'dbname' => $database_name,
    }
  }
  $options = {
    'autodb_idle_timeout' => '10',
    'server_connect_timeout' => '3',
    'server_idle_timeout' => '10',
    'server_lifetime' => '300',
    'server_login_retry' => '1',
  }

  class { 'twitch_postgresql::lib::healthcheck':
    database_name => $database_name,
    ports         => [$listen_port],
    user          => 'healthcheck',
  }

  class { 'watcher::pgbouncer_stats':
    ports => [$listen_port],
  }

  twitch_pgbouncer::instance { 'usherdb':
    listen_port         => $listen_port,
    default_pool_size   => $default_pool_size,
    max_client_conn     => '270000',
    userlist            => $userlist,
    admin_users         => $admin_users,
    databases           => $databases,
    options             => $options,
    database_name       => $database_name,
    database_env        => $database_env,
    rebouncer_hotspares => $hotspares,
  }

  twitch_sandstorm_agent::template { 'nagios_postgres_secret':
    ensure      => 'present',
    destination => '/var/lib/nagios/.pgpass',
    mode        => '0600',
    owner       => 'nagios',
    group       => 'nagios',
    contents    => template('twitch_pgbouncer/postgres.pgpass.erb'),
  }

  twitch_sandstorm_agent::template { 'nagios_root_postgres_secret':
    ensure      => 'present',
    destination => '/root/.pgpass',
    mode        => '0600',
    owner       => 'root',
    group       => 'root',
    contents    => template('twitch_pgbouncer/postgres.pgpass.erb'),
  }

  # Add passive checks
  twitch_nrdp::check { 'check_pgbouncer_tcp':
    ensure       => 'present',
    service_name => 'check_pgbouncer_tcp',
    command      => '/usr/lib/nagios/plugins/check_tcp -p 6543',
    interval     => 1,
    retry        => 2,
  }

  twitch_nrdp::check { 'check_pgbouncer_health':
    ensure         => 'present',
    service_name   => 'check_pgbouncer_health',
    command        => '/usr/local/monitor_scripts/check_postgres_health.py --check=PGB --dbport=6543',
    interval       => 5,
    retry          => 2,
    retry_interval => 2,
  }

  # logs into cloudwatch logs for SIRT-5401
  twitch_svclogs::logfile { 'pgbouncer_usherdb.log':
    filename        => 'pgbouncer_usherdb.log',
    log_stream_name => "${::pqdn}/var/log/jtv/pgbouncer_usherdb.log",
    use_milliner    => false,
  }

  twitch_svclogs::logfile { 'pgbouncer.log':
    filename        => 'pgbouncer.log',
    log_stream_name => "${::pqdn}/var/log/jtv/pgbouncer.log",
    use_milliner    => false,
  }

  twitch_svclogs::logfile { 'syslog':
    filename        => 'syslog',
    log_dir         => '/var/log',
    log_stream_name => "${::pqdn}/var/log/syslog",
    use_milliner    => false,
  }

  twitch_svclogs::logfile { 'auth.log':
    filename        => 'auth.log',
    log_dir         => '/var/log',
    log_stream_name => "${::pqdn}/var/log/auth.log",
    use_milliner    => false,
  }

}
