define twitch_pgbouncer::rebouncer(
  $package_ensure = 'latest',
  $deploy_env,
  $database_name,
  $config_dir,
  $config_file,
  $pgbouncer_name,
  $databases,
  $hotspares,
  $admin_users,
  $userlist_file,
  $default_pool_size,
  $ignore_startup_parameters,
  $pgbouncer_port,
  $rebouncer_port,
  $max_client_conn,
  $init_name,
  $pool_mode,
  $socket_dir,
  $pgbouncer_options,
  $user,
  $group,
  $ss_team = $twitch_pgbouncer::ss_team,
) {
  package { 'rebouncer':
    ensure => $package_ensure,
    tag    => 'pgbouncer',
  }

  twitch_pgbouncer::rebouncer_pgconfig { "${pgbouncer_name}_master":
    config_dir                  => $config_dir,
    databases                   => $databases,
    admin_users                 => $admin_users,
    userlist_file               => $userlist_file,
    default_pool_size           => $default_pool_size,
    ignore_startup_parameters   => $ignore_startup_parameters,
    listen_port                 => $pgbouncer_port,
    max_client_conn             => $max_client_conn,
    init_name                   => $init_name,
    pool_mode                   => $pool_mode,
    socket_dir                  => $socket_dir,
    options                     => $options,
    user                        => $user,
    group                       => $group,
    require                     => Package['rebouncer'],
  }

  file { $config_file:
    ensure  => link,
    target  => "${config_dir}/${pgbouncer_name}_master.ini",
    owner   => $user,
    group   => $group,
    require => Package['rebouncer'],
  }

  $hotspare_defaults = {
    config_dir                  => $config_dir,
    databases                   => $databases,
    admin_users                 => $admin_users,
    userlist_file               => $userlist_file,
    default_pool_size           => $default_pool_size,
    ignore_startup_parameters   => $ignore_startup_parameters,
    listen_port                 => $pgbouncer_port,
    max_client_conn             => $max_client_conn,
    init_name                   => $init_name,
    pool_mode                   => $pool_mode,
    socket_dir                  => $socket_dir,
    options                     => $options,
    user                        => $user,
    group                       => $group,
    require                     => Package['rebouncer'],
  }

  $hotspare_hash = host_array_to_hash($hotspares, "${pgbouncer_name}_hotspare")
  create_resources('twitch_pgbouncer::rebouncer_pgconfig', $hotspare_hash, $hotspare_defaults)

  twitch_sandstorm_agent::template { 'rebouncer.ini':
    ensure          => present,
    destination     => "${config_dir}/rebouncer.ini",
    contents        => template("${module_name}/rebouncer.ini.erb"),
    mode            => '0640',
    owner           => $user,
    group           => $group,
    require         => Package['rebouncer'],
    restart_command => 'sudo svc -t /var/lib/service/rebouncer',
  }

  $args = "-config ${config_dir}/rebouncer.ini -http localhost:${rebouncer_port}"
  $daemon = "/usr/bin/rebouncer ${args} 2>&1"

  ::daemontools::supervise { 'rebouncer':
    daemon     => $daemon,
    daemon_dir => '/var/lib/service',
    require    => [Package['rebouncer'], Twitch_sandstorm_agent::Template['rebouncer.ini'], File[$config_file]],
    subscribe  => [Package['rebouncer'], Twitch_sandstorm_agent::Template['rebouncer.ini'], File[$config_file]],
    syslog     => 'local3',
    user       => $user,
    wd         => '/tmp',
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
    ],
  }
}
