#!/bin/bash
# this script is copied from upstream PIMMS package, its used to generate a config file from a template using envsubst

set -xue -o pipefail

filter_facter() {
  # delete null values, map to 'key=value' syntax
  jq -r 'del(.[]|select(.==null))|to_entries|map("\(.key)=\(.value|tostring)")|.[]'
}

# facter magic: call facter one time, convert json to kv pairs, export for use below
for v in $(facter -p -j default_gateway_interface ipaddress_primary | filter_facter); do
  export $v
done

INPUT_FILE="/etc/pimmsd-integ-beta/pimmsd-integ-beta.conf.template"
OUTPUT_FILE="${INPUT_FILE%.*}"
# Use ec2-instance credentials as default (assume we're running on an ec2 instance)
CREDENTIALS_URL="${AWS_CONTAINER_CREDENTIALS_FULL_URI:=http://169.254.169.254/latest/meta-data/identity-credentials/ec2/security-credentials/ec2-instance}"

CREDENTIALS_URL="$CREDENTIALS_URL" IFACE="$default_gateway_interface" FAKE_HOSTNAME="$(hostname -f)" FAKE_IP="$ipaddress_primary" /usr/bin/envsubst < $INPUT_FILE > $OUTPUT_FILE
chown pimmsd:root $OUTPUT_FILE
chmod 644 $OUTPUT_FILE
