class twitch_pimmsd (
  $package_name = $twitch_pimmsd::params::package_name,
  $ensure       = $twitch_pimmsd::params::ensure,
) inherits twitch_pimmsd::params {

  include ::systemd
  include ::twitch::packages
  include ::milliner

  realize(Package['jq'])

  case $ensure {
    'absent': {
      # absent/removal case
      $package_ensure = 'absent'
      $service_ensure = false
      $conf_ensure    = 'absent'
      Service[$service_name] -> Package[$package_name]
    }
    default: {
      $package_ensure = $ensure
      $service_ensure = true
      $conf_ensure    = 'present'
      Package[$package_name] ~> Service[$service_name]
    }
  }

  package { $package_name:
    ensure => $package_ensure,
  }

  # XXX: bug filed with PIMMS to fix logrotate error:
  # > Ignoring pimmsd-integ-beta because the file owner is wrong (should be root or user with uid 0).
  # need to set everywhere currently to stop files from growing
  file { '/etc/logrotate.d/pimmsd-integ-beta':
    ensure  => $conf_ensure,
    owner   => 'root',
    group   => 'root',
    require => Package[$package_name],
  }

  # this file is maintained by upstream packaging. It generates a working config from a template (also included in package)
  # we customize this generate script so it can use facter facts to fill in IPAddress and Interface names
  file { '/usr/lib/pimmsd-integ-beta/sbin/generate-config.sh':
    ensure  => $conf_ensure,
    mode    => '0744',
    group   => 'root',
    source  => 'puppet:///modules/twitch_pimmsd/generate-config.sh',
    require => [
      Package[$package_name], # dirs are created by package
      Package['jq'],
    ],
  }

  systemd::service::dropin { $service_name:
    ensure            => $conf_ensure,
    environment_files => [
      '-/etc/profile.d/proxy.sh',
      '/etc/milliner-client-env.sh',
    ],
    execstartpre      => [ # XXX: These overrides have been reported upstream to fix, so we can remove eventually.
      '', # resets the stack, and overrides all base ExecStartPre stanzas
      '+/usr/lib/pimmsd-integ-beta/sbin/generate-config.sh',
    ],
    timeoutstartsec   => '10s',  # increased from 5s because of ExecStartPre steps
    runtime_directory => 'pimmsd-integ-beta',
    dropin_order      => '01',
    dropin_name       => 'twitch',
    notify            => Service[$service_name],
  }

  service { $service_name:
    ensure  => $service_ensure,
    enable  => $service_ensure,
    require => [
      Class['::systemd'],
      Class['::milliner'],
    ],
  }
}
