require 'puppet/provider/package/pip'

Puppet::Type.type(:package).provide :twitch_pip,
  :parent => :pip do

  has_feature :installable, :uninstallable, :upgradeable, :versionable, :install_options

  desc <<-'EOT'
    Twitch pip package provider.
    Uses twitch artifactory pypi repo instead of an external one.
  EOT

  # Ask the PyPI API for the latest version number.  There is no local
  # cache of PyPI's package list so this operation will always have to
  # ask the web service.
  # overload this method to check twitch artifactory. - ghalim
  def latest
    http_proxy_host = Puppet::Util::HttpProxy.http_proxy_host
    http_proxy_port = Puppet::Util::HttpProxy.http_proxy_port
    if http_proxy_host && http_proxy_port
      proxy = "#{http_proxy_host}:#{http_proxy_port}"
    else
      # nil is acceptable
      proxy = http_proxy_host
    end

    client = XMLRPC::Client.new2("https://pypi.internal.justin.tv/simple", proxy)
    client.http_header_extra = {"Content-Type" => "text/xml"}
    client.timeout = 10
    result = client.call("package_releases", @resource[:name])
    result.first
  rescue Timeout::Error => detail
    raise Puppet::Error, "Timeout while contacting pypi.internal.justin.tv: #{detail}", detail.backtrace
  end
end
