require 'puppet/provider/package/pip'

Puppet::Type.type(:package).provide :twitch_pip3,
  :parent => :twitch_pip do

  has_feature :installable, :uninstallable, :upgradeable, :versionable, :install_options

  desc <<-'EOT'
    Twitch pip3 package provider.
    Enables pypi installations using a real 'pip3'.
    Depends on pip3 installed by 'python3-pip' deb via twitch_pip::pip3
  EOT

  has_feature :installable, :uninstallable, :upgradeable, :versionable, :install_options

  def self.cmd
    "/usr/bin/pip3"
  end
end
