# @summary
#  Adds default, global pip installation settings.
#
class twitch_pip::config (
){

  # set upstream to our pypi if installing via pip in /etc/pip.conf
  # Legacy upstream also persisted in defining a pip conf for the root user 
  # in core::configs::user_configs (revisit in phase 2)
  if ($::packer_build_name) {
    ini_setting { 'index-url':
      path    => '/etc/pip.conf',
      section => 'global',
      setting => 'index-url',
      value   => 'https://pypi.internal.justin.tv/simple',
    }

    ini_setting { 'timeout':
      path    => '/etc/pip.conf',
      section => 'global',
      setting => 'timeout',
      value   => '120',
    }

    ini_setting { 'version check':
      path    => '/etc/pip.conf',
      section => 'global',
      setting => 'disable_pip_version_check',
      value   => '1',
    }
  }

}
