# twitch_pip
#
# Main class, includes all other classes.
#
# @param get_pip_url
#   The URL that the machine will get the bootstrap the latest pip binary from.
#
#
# @param pip_version
#   If install_method is set to 'easy_install', specify which version of pip to easy_install with. 
#   Default value: depends on ::lsbdistcodename.
#
#
class twitch_pip (
  $get_pip_url    = $twitch_pip::params::get_pip_url,
  $pip_version    = $twitch_pip::params::pip_version,
) inherits twitch_pip::params {

  validate_string($get_pip_url)
  validate_string($pip_version)

  contain 'twitch_pip::install'
  contain 'twitch_pip::config'

  Class['twitch_pip::install'] -> Class['twitch_pip::config']

}
