# @summary
#  Installs pip either via pip bootstrap or easy_install
#
class twitch_pip::install (
  $get_pip_url        = $twitch_pip::params::get_pip_url,
  $pip_version        = $twitch_pip::params::pip_version,
  $setuptools_version = $twitch_pip::params::setuptools_version,
) {

  require openssl

  if versioncmp($::operatingsystemmajrelease, '20.04') >= 0 {
      $archive_ensure = 'absent'
      require twitch_pip::pip3
    } else {
      $archive_ensure = 'present'
  }

  if $setuptools_version {
    $extract_args = "pip==${pip_version} setuptools==${setuptools_version}"
  } else {
    $extract_args = "pip==${pip_version}"
  }

  file {'/tmp/get-pip.py':
    ensure => absent,
  }

  # bootstrap pip and extract the latest version's binary into 
  archive { '/tmp/get-pip.py':
    ensure          => $archive_ensure,
    source          => $get_pip_url,
    extract         => true,
    extract_command => "/usr/bin/python %s ${extract_args}",
    extract_path    => '/tmp',
    cleanup         => true,
    creates         => '/usr/local/bin/pip',
    provider        => 'wget',
    user            => 'root',
    group           => 'root',
    require         => File['/tmp/get-pip.py'],
  }
}
