# @summary
#  A simple resource definition to install pip modules without a virtualenv.
#  See python::pip for installing with a virtualenv.
define twitch_pip::module (
  $pip_ensure      = undef,
  $pip_provider    = 'pip',
  $pip_source      = undef,
  $pip_name        = undef,
) {

  include twitch_pip

  validate_string($pip_ensure)
  validate_string($pip_provider)

  if ($pip_name) {
    $real_name = $pip_name
  } else {
    $real_name = $name
  }

  if !defined(Package[$real_name]) {
    package{ $real_name:
      ensure   => $pip_ensure,
      provider => $pip_provider,
      require  => Class['twitch_pip::install'],
    }
  }
}
