# @summary
#  These are the configurable parameters for twitch_pip
#
class twitch_pip::params {

  # set the get-pip uri based on python_release
  $get_pip_uri = versioncmp($::python_release, '3.6') ? {
    '-1' => $::python_release,
    default => undef
  }

  $get_pip_url    = "https://bootstrap.pypa.io/pip/${get_pip_uri}/get-pip.py"

  # $pip_version and $python_version 
  $pip_version = $::operatingsystemmajrelease ? {
    '16.04' => '8.1.1',
    '18.04' => '9.0.1',
    default  => '8.1.1'
  }

  # ensure we have a setuptools compatible with 3.5
  $setuptools_version = $::python_release ? {
    '3.5'   => '51.3.3',
    '2.7'   => '20.9.0',
    default => undef,
  }
}
