# Simple, safe, atomic lock
function devdb-lock() {
  lockdir=$1
  if mkdir $lockdir; then
    # this is a new instance, store the pid
    echo $$ > ${lockdir}/PID
  else
    echo "Rotation is already running, pid $(<${lockdir}/PID)" >&2
    exit 1
  fi
  trap 'rm -rf "${lockdir}" >/dev/null 2>&1' 0
  trap "exit 2" 1 2 3 13 15
}

# pass in 2 parameters
# * pgbouncer instance, eg, proxy1
# * who to start: 'local' or 'remote'
# * who to stop: 'local' or 'remote'
function bounce_pgbouncer() {
  instance="${1}"
  start="${2}"
  stop="${3}"
  sudo /bin/systemctl stop "pgbouncer@${instance}_${stop}.service"
  sudo /bin/systemctl start "pgbouncer@${instance}_${start}.service"
}
