#!/usr/bin/ruby
require 'net/http'
require 'uri'
require 'optparse'


EXIT_STRING_TO_CODE = {
    'OK' =>  0,
    'WARN' => 1,
    'CRITICAL' =>  2,
    'UNKNOWN' => 3
}

all_errors = []

def check_pg_healthstats(uri)
  errors = []
  begin
    parsed = URI.parse(uri)
    response = Net::HTTP.get_response(parsed)
  rescue Exception => e
    errors << "#{e.message} @ pg-healthstats: #{uri}"
  end
  errors << "#{response.message} @ pg-healthstats #{uri}" if response and response.code != '200'
  errors
end


def exit_with_code(code, text="")
  puts "#{code} #{text}"
  exit EXIT_STRING_TO_CODE[code]
end


options = {
  :healthcheck_url => nil,
  :url => "http://localhost:6545/port/all",
}

OptionParser.new do |opts|
  opts.banner = "Usage: #{File.basename($0)} [options]"

  opts.separator ""

  opts.on("-u", "--healthurl HEALTHCHECK URL", "curls url looking for pg-healthstats. example: http://localhost:6545/port/all") do |v|
    options[:url] = v
  end
end.parse!

all_errors << check_pg_healthstats(options[:url])

all_errors.flatten!

if all_errors.size > 0
  exit_with_code("CRITICAL",all_errors.to_s)
end
exit_with_code('OK')
