with treatments as
 (select er.id as reduction_id, source.id as source_id, target.id as target_id
  from email_reduction_experiments_20150224 er
  join users source on source.login = er.login
  join users target on target.login = er.channel
  where treatment_group = 'treatment'
  and er.id > {start}
  order by er.id asc
  limit {limit})
update favorites set block_notifications = 'true'
from treatments
where from_user_id = treatments.source_id and to_user_id = treatments.target_id
returning treatments.reduction_id
/* job updates favorites to block notifications for science experiment */
