update copyright_holders
  set email = ( CASE  
    WHEN email is NULL
      THEN NULL
    WHEN email not like 'qa.twitch%gmail.com' and email not like '%twitch.tv' and email not like '%justin.tv'
      THEN 'staging-' || id || '@example.com'
    ELSE email
    END
    ), about = NULL
  where id in (
    select id from copyright_holders 
    where id > {start}
    order by id
    limit {limit}
    )
returning id
/*this will change the email column of the copyright_holders table and set the about column to null */
