update dmcas
  set user_email = ( CASE  
    WHEN user_email is NULL
      THEN NULL
    WHEN user_email not like 'qa.twitch%gmail.com' and user_email not like '%twitch.tv' and user_email not like '%justin.tv'
      THEN 'staging-' || id || '@example.com'
    ELSE user_email
    END
    ), company_email = ( CASE  
    WHEN company_email is NULL
      THEN NULL
    WHEN company_email not like 'qa.twitch%gmail.com' and company_email not like '%twitch.tv' and company_email not like '%justin.tv'
      THEN 'staging-' || id || '@example.com'
    ELSE company_email
    END
    ), language = NULL
  where id in (
    select id from dmcas 
    where id > {start}
    order by id
    limit {limit}
    )
returning id
/* remove pii from staging databases, this changes the company and user emails and nulls the language field for dmca table*/
