update user_phone_number_properties 
  set phone_number = ( CASE  
    WHEN phone_number is NULL
      THEN phone_number
    ELSE regexp_replace(phone_number, '[0-9]', '5', 'g')
    END
    )
  where id in (
    select id from user_phone_number_properties 
    where id > {start}
    order by id
    limit {limit}
    )
returning id
/* set phonenumber to 5 from staging databases */
