update users 
  set email = ( CASE  
    WHEN email is NULL
      THEN NULL
    WHEN email = ''
      THEN email
    WHEN email not like 'qa.twitch%gmail.com' and email not like '%twitch.tv' and email not like '%justin.tv'
      THEN 'staging-' || id || '@example.com'
    ELSE email
    END
    )
  , remote_ip =  trunc(random()*254+1)::text ||'.'|| trunc(random()*254+1)::text ||'.'|| trunc(random()*254+1)::text ||'.'|| trunc(random()*254+1)::text
  , birthday = CASE WHEN birthday IS NULL THEN NULL ELSE DATE '1980-02-29' END
  where id in (
    select id from users 
    where id > {start}
    order by id
    limit {limit}
    )
returning id
/* remove pii from staging databases */
