class twitch_postgresql::instance::server(
  $user = 'postgres',
  $database_name,
  $database_user,
  $user_password,
  $database_role,
  $schema,
  $organization = 'd8a',
  $repo = 'patroni',
  $wale_s3_prefix,
  $patroni_config = undef,
)inherits twitch_postgresql {

  include postgresql::server::contrib

  #add pg_hba resource, users that exist
  # installing psycopg2 and pyyaml from apt-get

  $aws                  = hiera('aws', false)
  $basedir              = '/var/lib/postgresql'
  $conf_file            = "${basedir}/${repo}/patroni.conf"
  $owner                = $user
  $version              = $postgresql::params::version
  $virtenv_basedir      = "${basedir}/virt_env"
  $virtenv_dir          = "${virtenv_basedir}/patroni"
  $ss_team              = $twitch_postgresql::ss_team

  realize(Package['libreadline-dev'])
  realize(Package['lzop'])
  realize(Package['pv'])

  class{ 'twitch_postgresql::lib::wal_e':
    wale_s3_prefix => $wale_s3_prefix,
    is_master      => $aws,
    enable_cron    => false,
    virtenv        => 'patroni'
  }

  class { 'twitch_postgresql::lib::server_devel':
    version => $version,
  }

  ##### install postgres server

  class { 'postgresql::server':
    listen_addresses => '*',
  }

  postgresql::server::role { $database_role:
    password_hash => postgresql_password($database_role, $user_password),
  }

  # postgresql::server::role { "patroni role":
  # password_hash => postgresql_password("patroni", "${user_password}"),
  # username      => 'patroni'
  # }

  # postgresql::server::role { "replication role":
  # password_hash => postgresql_password("replication", "${user_password}"),
  # username      => 'replicator',
  # replication   => true,
  # }

  postgresql::server::db { $database_name:
    user     => $database_user,
    password => postgresql_password($database_user, $user_password),
  }

  postgresql::server::schema { $schema:
    owner  => $database_role,
    db     => $database_name,
    schema => 'test_schema'
  }

  postgresql::server::pg_hba_rule { 'allow application network to access app database':
    description => 'Open up postgresql for access from 0.0.0.0/0',
    type        => 'host',
    database    => 'all',
    user        => 'all',
    address     => '0.0.0.0/0',
    auth_method => 'md5',
  }

  postgresql::server::pg_hba_rule { 'allow access app database from vpc cidr':
    description => "Open up postgresql for access from ${patroni_config[vpc_CIDR_range]}",
    type        => 'host',
    database    => 'all',
    user        => 'patroni',
    address     => $patroni_config[vpc_CIDR_range],
    auth_method => 'md5',
  }

  file { "${basedir}/.pgpass":
    ensure  => 'file',
    mode    => '0600',
    owner   => 'postgres',
    group   => 'postgres',
    require => Package['postgresql-server'],
    source  => "puppet:///modules/${module_name}/pgpass",
  }
  file { "${basedir}/.psqlrc":
    ensure  => 'file',
    mode    => '0644', # -rw-r--r--
    owner   => 'postgres',
    group   => 'postgres',
    require => Package['postgresql-server'],
    source  => "puppet:///modules/${module_name}/psqlrc",
  }

  # Same cron as found in manifests/classes/cron/pg_log_cleanup.pp
  cron { 'pg_log_cleanup':
    command => 'find /var/log/postgresql/ -name "postgresql*" -type f -mtime +7 -delete',
    require => Package['postgresql-server'],
    user    => 'postgres',
    hour    => '0',
  }

}

