class twitch_postgresql::instance::servicedb (
  $client_hosts = undef,
  $database_name = undef,
  $db_environment = pick($::twitch_environment, $twitch_environment, 'production'),
  $master_db = $fqdn,
  $puppetize_database = false,
  $postgres_users = false,
  $promiscuous_access = false,
  $replication_hosts = undef,
  $replication_targets = undef,
  $restore_wal_e = true,
  $repmgr_topology = undef,
) inherits twitch_postgresql {

  $basedir = '/var/lib/postgresql'
  $version = $postgresql::params::version

  class { 'postgresql::server':
    listen_addresses => '*',
  }

  class { 'twitch_postgresql::instance::common':
    client_hosts        => $client_hosts,
    database_name       => $database_name,
    db_environment      => $db_environment,
    master_db           => $master_db,
    postgres_users      => $postgres_users,
    puppetize_database  => $puppetize_database,
    restore_wal_e       => $restore_wal_e,
    replication_hosts   => $replication_hosts,
    replication_targets => $replication_targets,
    repmgr_topology     => $repmgr_topology,
  }

  # XXX AGB: this is a compromise until such time that we can populate
  # the actual clients from some kind of dynamic store. In a perfect
  # world, single purpose databases should not allow connections from
  # anyone. 2014-10-17
  if $promiscuous_access {
    postgresql::server::pg_hba_rule { 'valid user access':
      description => 'allow users to login with password in datacenter',
      type        => 'host',
      database    => 'all',
      user        => 'all',
      address     => '10.0.0.1/8',
      auth_method => 'md5',
      order       => '110',
    }
  }

}

