class twitch_postgresql::instance::witness (
  $database_name = undef,
  $database_env  = pick($::twitch_environment, $twitch_environment, 'production'),
  $repmgr_topology = undef,
  $postgres_users = false,
) inherits twitch_postgresql {

  $basedir = '/var/lib/postgresql'
  $version = $postgresql::params::version

  class { 'postgresql::server':
    listen_addresses => '*',
  }

  class { 'twitch_postgresql::instance::common':
    database_name      => $database_name,
    db_environment     => $database_env,
    master_db          => $::fqdn,
    postgres_users     => $postgres_users,
    puppetize_database => false,
    restore_wal_e      => false,
    repmgr_topology    => $repmgr_topology,
  }
}
