class twitch_postgresql::lib::antifreeze(
  $package_ensure = 'present',
){
  # The extension has been found to be too risky since we crashed
  # after an ABI change in a minor version upgrade.

  # package { 'postgresql-9.3-antifreeze':
  #   name    => 'postgresql-9.3-antifreeze',
  #   ensure  => $package_ensure,
  #   require => Package['postgresql-server'],
  #   tag     => 'postgresql',
  # }
  # package { 'postgresql-9.3-antifreeze-dbg':
  #   name    => 'postgresql-9.3-antifreeze-dbg',
  #   ensure  => $package_ensure,
  #   require => Package['postgresql-server'],
  #   tag     => 'postgresql',
  # }

  file { '/var/lib/postgresql/bin/avoid_anti_wraparound_vacuums':
    ensure  => 'present',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/avoid_anti_wraparound_vacuums",
  }

  cron { 'avoid_anti_wraparound_vacuums':
    command => "stdbuf -oL -eL /var/lib/postgresql/bin/avoid_anti_wraparound_vacuums -H /var/run/postgresql -t 18000 2>&1 | logger -p local3.info -t antifreeze-vacuum",
    require => File['/var/lib/postgresql/bin/avoid_anti_wraparound_vacuums'],
    user    => 'postgres',
    hour     => '7',
    minute   => '30',
  }
}
