# This class installs postgresql client development libraries. See README.md for more
# details.
class twitch_postgresql::lib::client_devel(
  $package_name   = undef,
  $package_ensure = 'present',
) {

  if ($package_name) {
    $install_pkg = $package_name
  } else {
    $install_pkg = 'libpq-dev'
  }

  validate_string($install_pkg)

  package { 'postgresql-devel':
    ensure => $package_ensure,
    name   => $install_pkg,
    tag    => 'postgresql',
  }

}
