define twitch_postgresql::lib::consul_service (
  $mode = 'transaction',
  $role, # master, replica, spare, etc.
) {

  # We take the name and split on hyphen. The last element is the port
  # and the prefix is the postgresql cluster name. For example, a name
  # of discovery-postgres-5432 is part of the 'discovery-postgres'
  # cluster and listening on port 5432.
  # XXX AGB: This is ugly and should use puppet's array selection once available. 2015-09-24
  $parts = split($name, '-')
  $port = $parts[-1]
  $prefix = join(delete_at($parts, -1), '-')

  consul::service { "${name}":
    check_interval => '2s',
    check_script   => "curl http://localhost:6545/port/${port}",
    consul_tags    => ["${twitch_environment}", "mode=${mode}", "healthcheck=http://${::fqdn}:6545/port/${port}"],
    port           => $port,
    service_name   => "${prefix}-${role}",
  }

}
