class twitch_postgresql::lib::data_collection(
){
  require twitch_postgresql

  include twitch_python
  include twitch_python::pip::install

  $basedir = '/var/lib/postgresql'

  file { '/var/lib/postgresql/healthcheck/datacollection.sh':
    ensure  => 'absent',
  }
  file { "${basedir}/env":
    ensure  => 'absent',
  }
  file { "${basedir}/env/datacollection":
    ensure  => 'absent',
  }
  cron { 'datacollection':
    ensure => 'absent',
  }
  cron { 'run_phc':
    ensure => 'absent',
  }
  cron {'datacollection listener':
    ensure  => 'absent',
  }
  file { "${basedir}/env/AWS_DEFAULT_REGION":
    ensure  => 'absent',
  }
  file { "${basedir}/env/AWS_ACCESS_KEY_ID":
    ensure  => 'absent'
  }
  file { "${basedir}/env/AWS_SECRET_ACCESS_KEY":
    ensure => 'absent'
  }
  file { "${basedir}/.aws/credentials":
    ensure => 'absent'
  }
  file { "${basedir}/.aws/config":
    ensure => 'absent'
  }

}
