# This class handles the development machines getting daily fresh data
class twitch_postgresql::lib::fresh_staging(
  $enabled = true,
  $master_db,
  $parent_cluster,
  $wal_e_cluster,
  $s3_bucket,
  $setup_day = '*',
  $setup_hour = '9',
  $setup_minute = '0',
  $teardown_day = '*',
  $teardown_hour = '1',
  $teardown_minute = '0',
) {

  include postgresql::globals
  $version = $::postgresql::globals::version
  $remote_host = $twitch_pgbouncer::instance::proxy_dev::remote_host

  notify{ 'Who is your remote_host?':
    message  => "Value of remote_host: ${remote_host}",
    loglevel => info,
  }

  $ensure_cron = $enabled ? {
    true  => 'present',
    false => 'absent',
  }
  if $remote_host {
    postgresql::server::pg_hba_rule { 'remote pgbouncer':
      description => 'Allow paired host pbouncer to connect',
      type        => 'host',
      database    => 'all',
      user        => 'all',
      address     => "${remote_host}/32",
      auth_method => 'md5',
      order       => '120',
    }
  }

  if $parent_cluster =~ /^sitedb.*/ {
    file { '/var/lib/postgresql/bin/devdb-setup-wale':
      ensure  => 'present',
      mode    => '0755', # -rwxr-xr-x
      owner   => 'postgres',
      group   => 'postgres',
      require => File['/var/lib/postgresql/bin'],
      source  => "puppet:///modules/${module_name}/bin/devdb-setup-wale",
    }

    cron { 'devdb_setup':
      ensure   => $ensure_cron,
      command  => 'stdbuf -oL -eL /var/lib/postgresql/bin/devdb-setup-wale | logger -p local3.info -t devdb-setup',
      require  => File['/var/lib/postgresql/bin/devdb-setup-wale'],
      user     => 'postgres',
      monthday => $setup_day,
      hour     => $setup_hour,
      minute   => $setup_minute,
    }
    sudo::conf {'postgres':
      priority => 10,
      source   => "puppet:///modules/${module_name}/rails-postgres-staging.sudo"
    }
  }

  file { '/var/lib/postgresql/bin/devdb-teardown-wale':
    ensure  => 'present',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/devdb-teardown-wale",
  }

  cron { 'devdb_teardown_wale':
    ensure   => $ensure_cron,
    command  => "stdbuf -oL -eL /var/lib/postgresql/bin/devdb-teardown-wale ${parent_cluster} ${version} ${master_db} ${wal_e_cluster} ${s3_bucket} | logger -p local3.info -t devdb-teardown",
    require  => File['/var/lib/postgresql/bin/devdb-teardown-wale'],
    user     => 'postgres',
    monthday => $teardown_day,
    hour     => $teardown_hour,
    minute   => $teardown_minute,
  }

  file { '/var/lib/postgresql/bin/devdb-lib.sh':
    ensure  => 'present',
    mode    => '0664', # -rw-rw-r--
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/devdb-lib.sh",
  }

  file { '/var/lib/postgresql/sql/scrub_email.sql':
    ensure  => 'absent',
  }
  file { '/var/lib/postgresql/sql/scrub_users.sql':
    ensure  => 'present',
    mode    => '0644',
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/sql'],
    source  => "puppet:///modules/${module_name}/sql/scrub_users.sql",
  }
  file { '/var/lib/postgresql/sql/scrub_dmca.sql':
    ensure  => 'present',
    mode    => '0644',
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/sql'],
    source  => "puppet:///modules/${module_name}/sql/scrub_dmca.sql",
  }
  file { '/var/lib/postgresql/sql/scrub_copyright_ip.sql':
    ensure  => 'present',
    mode    => '0644',
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/sql'],
    source  => "puppet:///modules/${module_name}/sql/scrub_copyright_ip.sql",
  }
  file { '/var/lib/postgresql/sql/scrub_copyrightholder.sql':
    ensure  => 'present',
    mode    => '0644',
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/sql'],
    source  => "puppet:///modules/${module_name}/sql/scrub_copyrightholder.sql",
  }
  file { '/var/lib/postgresql/sql/scrub_phonenumbers.sql':
    ensure  => 'present',
    mode    => '0644',
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/sql'],
    source  => "puppet:///modules/${module_name}/sql/scrub_phonenumbers.sql",
  }

}
