class twitch_postgresql::lib::healthcheck(
  $cluster,
  $database_name,
  $deploy_env = pick($::twitch_environment, $twitch_environment, 'production'),
  $enabled = true,
  $package_ensure = 'latest',
  $ports = ['5432'],
  $user = undef,
  $absolute_threshold = undef, # default 50ms threshold
  $relative_threshold = undef, # default 2.0x cluster average threshold
) {

  validate_array($ports)
  validate_bool($enabled)

  # wrapper module contains repo and global postgresql configs
  require twitch_postgresql

  class { 'twitch_postgresql::lib::pgpass':
    database_name => $database_name,
    database_env => $deploy_env,
  }

  twitch_postgresql::lib::pgpass_line { "pgpass_healthcheck":
    database_name => $database_name,
    database_env  => $deploy_env,
    database_user => 'healthcheck',
  }

  package { 'pg-healthcheck':
    ensure => $package_ensure,
    tag    => 'postgresql',
  }

  $down = $enabled ? {
    false => 'force',
    true  => 'false',
  }

  $pg_ports = prefix($ports, '-port ')
  $cl_ports = join($pg_ports, " ")
  $cl_user = $user ? {
    undef   => '',
    default => " -user ${user}",
  }
  $cl_absolute = $absolute_threshold ? {
    undef   => '',
    default => " -absolute-threshold ${absolute_threshold}",
  }
  $cl_relative = $relative_threshold ? {
    undef   => '',
    default => " -relative-threshold ${relative_threshold}",
  }

  $args = "-cluster ${cluster} -database ${database_name} ${cl_ports}${cl_user}${cl_absolute}${cl_relative}"
  $daemon = "/usr/bin/pg-healthcheck ${args} 2>&1"

  ::daemontools::supervise { 'pg-healthcheck':
    daemon     => $daemon,
    daemon_dir => '/var/lib/service',
    down       => $down,
    require    => Package['pg-healthcheck'],
    subscribe  => Package['pg-healthcheck'],
    syslog     => 'local3',
    user       => 'postgres',
    wd         => '/tmp',
    predaemon      => [
      "export ENVIRONMENT=${deploy_env}",
    ],
  }
}
