# This class is for killing idle transactions.
# XXX AGB: This should probably be a define. 2014-10-10
class twitch_postgresql::lib::idle_transaction_killer(
  $basedir,
  $database_name,
  $frequency = '*/2',
  $timeout = '3 minutes',
) {
  file { "${basedir}/bin/kill-idle-transactions":
    ensure  => 'file',
    mode    => '0755',
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/kill-idle-transactions",
  }

  cron { "pg_kill_idle_x_${database_name}":
    command => "${basedir}/bin/kill-idle-transactions ${database_name} '${timeout}' 2>&1 | logger -p local3.info -t pg_kill_idle_x_${database_name}",
    require => File["${basedir}/bin/kill-idle-transactions"],
    user    => 'postgres',
    minute  => $frequency,
  }
}
