class twitch_postgresql::lib::migrations(
  $database_name,
) {

  package { 'iceman':
    ensure  => 'latest',
    tag     => 'postgresql',
    require => Package['postgresql-server'],
  }

  # This link supports the usual way to do migrations. As postgres user `iceman -e ${ENV} up`.
  file { '/var/lib/postgresql/iceman':
    ensure  => 'link',
    owner   => 'postgres',
    group   => 'postgres',
    require => Package['postgresql-server'],
    target  => "/opt/twitch/migrations/${database_name}/current/iceman",
  }

  # This is the old way we did migrations.
  file { '/var/lib/postgresql/db':
    ensure  => 'absent',
  }

  # This link makes it easier to find all your migrations.
  file { '/var/lib/postgresql/migrations':
    ensure  => 'link',
    owner   => 'postgres',
    group   => 'postgres',
    require => Package['postgresql-server'],
    target  => "/opt/twitch/migrations",
  }

}
