# This class is for a simple daily snapshot
class twitch_postgresql::lib::periodic_backup(
  $destination,
  $hour,
  $minute,
  $destination,
  $owner,
  $ssh_key_target,
  $sandstorm_ssh_key_path,
  $ssh_key_needed,
) {

  if $ssh_key_needed != undef {
    twitch_sandstorm_agent::template { 'postgres_backup_ssh_keys':
      ensure      => 'present',
      destination => $ssh_key_target,
      mode        => '0600',
      owner       => $owner,
      group       => 'root',
      key         => "${sandstorm_ssh_key_path}"
    }
  }

  file { '/var/lib/postgresql/bin/backup-all':
    ensure  => 'file',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/backup-all",
  }

  # XXX AGB: This also depends on appropriate key exchange between the host and destination host. 2014-07-30
  cron { 'pg_backup_all':
    command => "/var/lib/postgresql/bin/backup-all ${destination} | logger -p local3.info -t backup-all",
    require => File['/var/lib/postgresql/bin/backup-all'],
    user    => 'postgres',
    hour    => $hour,
    minute  => $minute,
  }

}
