class twitch_postgresql::lib::pgpass(
  $database_name,
  $database_env,
) {
  $basedir = '/var/lib/postgresql'
  $ensure_pgpass = $::clean ? {
    'true'  => 'file',
    default => 'absent',
  }

  if $::clean == 'true' {
    twitch_sandstorm_agent::template_composite { "pgpass":
      ensure      => present,
      mode        => '0600',
      owner       => 'postgres',
      group       => 'postgres',
      destination => "${basedir}/.pgpass",
    }

    twitch_postgresql::lib::pgpass_line { "pgpass_replication":
      database_name => $database_name,
      database_env => $database_env,
      database_user => 'replication'
    }

    twitch_postgresql::lib::pgpass_line { "pgpass_backup":
      database_name => $database_name,
      database_env => $database_env,
      database_user => 'backup',
    }

    twitch_postgresql::lib::pgpass_line { "pgpass_pgbouncer_stats":
      database_name => 'common',
      database_env => $database_env,
      database_user => 'pgbouncer-stats',
    }
  }
  else {
    file { "${basedir}/.pgpass":
      ensure  => 'absent',
      mode    => '0600',
      owner   => 'postgres',
      group   => 'postgres',
    }
  }
  file { "${basedir}/.psqlrc":
    ensure  => $ensure_pgpass,
    mode    => '0644', # -rw-r--r--
    owner   => 'postgres',
    group   => 'postgres',
    source  => "puppet:///modules/${module_name}/psqlrc",
  }
}
