# This class is for issuing a periodic backup to barman
class twitch_postgresql::lib::pitr_backup(
  $cluster,
  $hour,
  $minute,
  $remote = 'media33.justin.tv',
) {
  file { '/var/lib/postgresql/bin/backup-pitr':
    ensure  => 'file',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/backup-pitr",
  }

  # XXX AGB: This also depends on appropriate barman setup for ${cluster} on ${remote}. 2014-10-28
  cron { 'pg_backup_pitr':
    command => "stdbuf -oL -eL /var/lib/postgresql/bin/backup-pitr ${cluster} ${remote} | logger -p local3.info -t backup-pitr",
    require => File['/var/lib/postgresql/bin/backup-pitr'],
    user    => 'postgres',
    hour    => $hour,
    minute  => $minute,
  }
}
