# This class prepares a host for export
class twitch_postgresql::lib::prepare_export {

  file { '/var/lib/postgresql/bin/prepare-export':
    ensure  => 'present',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/prepare-export",
  }

  sudo::conf {'postgres':
    priority => 10,
    source   => "puppet:///modules/${module_name}/prepare-export.sudo"
  }

}
