# This class is for periodic relation backup
class twitch_postgresql::lib::relation_backups(
  $day = '*',
  $hour = 1,
  $minute = 1,
  $relations,
  $s3_destination,
  $schema,
) {
  validate_array($relations)

  file { '/var/lib/postgresql/bin/backup-relations':
    ensure  => 'file',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/backup-relations",
  }

  # XXX AGB: This also depends on appropriate key exchange between the host and destination host. 2015-03-25
  if (size($relations) > 0) {
    $tables = join($relations, " ")
    cron { "pg_backup_${schema}_relations":
      ensure   => $ensure_cron,
      command  => "stdbuf -oL -eL /var/lib/postgresql/bin/backup-relations ${s3_destination} ${schema} ${tables} | logger -p local3.info -t backup-relations",
      require  => File['/var/lib/postgresql/bin/backup-relations'],
      user     => 'postgres',
      monthday => $day,
      hour     => $hour,
      minute   => $minute,
    }
  }
}
