# This class adds the ability to rsync from the postgresql data
# directory. This should probably be avoided in production hosts. The
# transfer is completely insecure and only works correctly when the
# databases are stopped and have an exact version match.
#
# In this example, usherdb is the database_name.
#
# $ rsync -arvP --delete postgres@usherdb13.sfo01::usherdb /tmp/main
class twitch_postgresql::lib::rsync(
  $database_name,
) {
  include postgresql::globals
  $version = $postgresql::globals::version

  include rsync::server
  rsync::server::module { "$database_name":
    path => "/var/lib/postgresql/${version}/main",
    secrets_file => '/etc/rsync.d/rsyncd.secrets',
    uid => 'postgres',
  }
  file { '/etc/rsync.d/rsyncd.secrets':
    content => 'postgres:postgres',
    mode => '0600',
    owner   => 'postgres',
    group   => 'postgres',
    require => Package['rsync','postgresql-server'],
  }
}
