# This class is for periodic shecma backup
class twitch_postgresql::lib::schema_backup(
  $day = '*',
  $enabled = true,
  $hour = 1,
  $minute = 0,
  $s3_destination,
  $schema,
) {
  file { '/var/lib/postgresql/bin/backup-schema':
    ensure  => 'file',
    mode    => '0755', # -rwxr-xr-x
    owner   => 'postgres',
    group   => 'postgres',
    require => File['/var/lib/postgresql/bin'],
    source  => "puppet:///modules/${module_name}/bin/backup-schema",
  }

  $ensure_cron = $enabled ? {
    true  => 'present',
    false => 'absent',
  }

  # XXX AGB: This also depends on appropriate key exchange between the host and destination host. 2015-03-25
  cron { "pg_backup_${schema}":
    ensure   => $ensure_cron,
    command  => "/var/lib/postgresql/bin/backup-schema ${remote_host} ${remote_path} ${schema} | logger -p local3.info -t backup-schema",
    require  => [File['/var/lib/postgresql/bin/backup-schema'],Class['twitch_python::pip::awscli']],
    user     => 'postgres',
    monthday => $day,
    hour     => $hour,
    minute   => $minute,
  }
}
