# #this is a test for using the package wal-e which is  Simple continuous archiving for Postgres
class twitch_postgresql::lib::wal_e(
  $cluster = undef,
  $db_environment = pick($twitch_environment, $::twitch_environment, 'production'),
  $enable_cron = false,
  $is_master = false,
  $virtenv="wal_e",
  $wale_s3_prefix,
  ){
# when using aws instance profile pass this flag --aws-instance-profile
  include postgresql::globals
  include twitch_python
  include twitch_python::pip::install

  realize(Package['python-gevent'])
  realize(Package['lzop'])

  $version            = $postgresql::globals::version
  $basedir            = '/var/lib/postgresql'
  $user               = 'postgres'
  $virtenv_basedir    = "${basedir}/virt_env"
  $virtenv_dir        = "${virtenv_basedir}/${virtenv}"
  $datadir            = "${basedir}/${version}/main/"
  $aws                = hiera('aws', 'false')
  $ss_team            = $twitch_postgresql::ss_team

  file { '/etc/wal-e.d':
    ensure  => "directory",
    owner   => "root",
    group   => "${user}",
    mode    => '0750',
    require => Package['postgresql-server'],
  }

  file { '/etc/wal-e.d/env':
    ensure  => "directory",
    owner   => "root",
    group   => "${user}",
    mode    => '0750',
    require => File['/etc/wal-e.d'],
  }

  #assuming wal-e will live on a box that is an aws instance, 
  file { '/etc/wal-e.d/env/WALE_S3_PREFIX':
    ensure  => "file",
    owner   => "root",
    group   => "${user}",
    mode    => '0750',
    require => File['/etc/wal-e.d/env'],
  }->
  file_line { "$wale_s3_prefix":
    ensure   => 'present',
    line     => "${wale_s3_prefix}",
    path     => "/etc/wal-e.d/env/WALE_S3_PREFIX",
    match    => "^s3://.*$",
  }
  file { '/etc/wal-e.d/env/AWS_REGION':
    ensure  => "file",
    owner   => "root",
    group   => "${user}",
    mode    => '0750',
    require => File['/etc/wal-e.d/env'],
  }->
  file_line { "wale_region":
    ensure   => "present",
    line     => "us-west-2",
    path     => "/etc/wal-e.d/env/AWS_REGION",
  }

# checking if aws instance to use aws key id and secret
# when using aws instance profile pass this flag wal-e --aws-instance-profile <command>
  file { "/etc/wal-e.d/env/AWS_ACCESS_KEY_ID":
    ensure  => 'absent'
  }
  file { "/etc/wal-e.d/env/AWS_SECRET_ACCESS_KEY":
    ensure => 'absent'
  }

  python::virtualenv { $virtenv_dir:
    owner   => "${user}",
    group   => "${user}",
    path    => [ '/usr/local/bin', '/usr/bin', '/bin' ],
    require => Class['twitch_python'],
    version => "3.5", # I'd prefer ${twitch_python::python_version} but that fails for uknown reasons. AGB 2018-10-29
  }

  python::pip { 'wal-e':
      pkgname    => 'wal-e==1.1.0',
      virtualenv => "${virtenv_dir}",
      owner      => "${user}",
  }
  python::pip { 'boto':
      pkgname    => 'boto==2.49.0',
      virtualenv => "${virtenv_dir}",
      owner      => "${user}",
  }

  if str2bool("$enable_cron") and str2bool("$is_master") {
    $ensure_walecron = 'present'
  }else{
    $ensure_walecron = 'absent'
  }

  $ensure_aws_instance = str2bool("$aws") ? {
    true  => 'absent',
    false => 'present',
  }
  if str2bool("$aws") {
    file { '/var/lib/postgresql/bin/backup-wale':
      ensure  => 'file',
      mode    => '0755', # -rwxr-xr-x
      owner   => 'postgres',
      group   => 'postgres',
      require => File['/var/lib/postgresql/bin'],
      source  => "puppet:///modules/${module_name}/bin/backup-wale",
    }
    cron { 'pg_backup_wale':
      command => "stdbuf -oL -eL /var/lib/postgresql/bin/backup-wale ${cluster} ${version} | logger -p local3.info -t backup-wale",
      ensure  => $ensure_walecron,
      require => File['/var/lib/postgresql/bin/backup-wale'],
      user    => 'postgres',
      hour    => 12,
      minute  => 30,
    }
    cron { 'wale cleanup cron':
      ensure  => $ensure_walecron,
      command => "envdir /etc/wal-e.d/env ${virtenv_dir}/bin/wal-e --aws-instance-profile delete --confirm retain 14",
      user    => 'postgres',
      hour    => 12,
      minute  => 35,
    }

  }
  else {
      twitch_sandstorm_agent::template { "wale_AWS_ACCESS_KEY_ID":
      destination     => "/etc/wal-e.d/env/AWS_ACCESS_KEY_ID",
      key             => "data-eng/wale/${db_environment}/${cluster}_AWS_ACCESS_KEY_ID",
      owner           => "root",
      group           => "${user}",
      mode            => '0750',
      require         => File['/etc/wal-e.d/env'],
      delete_dest     => true,
    }
    twitch_sandstorm_agent::template { "wale_AWS_SECRET_ACCESS_KEY":
      destination     => "/etc/wal-e.d/env/AWS_SECRET_ACCESS_KEY",
      key             => "data-eng/wale/${db_environment}/${cluster}_AWS_SECRET_ACCESS_KEY",
      owner           => "root",
      group           => "${user}",
      mode            => '0750',
      require         => File['/etc/wal-e.d/env'],
      delete_dest     => true,
    }
    cron { 'walebackup cron':
      ensure  => $ensure_walecron,
      command => "envdir /etc/wal-e.d/env ${virtenv_dir}/bin/wal-e backup-push ${datadir}",
      user    => 'postgres',
      hour    => 12,
      minute  => 30,
    }
    cron { 'wale cleanup cron':
      ensure  => $ensure_walecron,
      command => "envdir /etc/wal-e.d/env ${virtenv_dir}/bin/wal-e delete --confirm retain 14",
      user    => 'postgres',
      hour    => 12,
      minute  => 35,
    }
  }

}
