define twitch_postgresql::replica_pg_hba($ip, $user, $auth_method) {
  postgresql::server::pg_hba_rule { "${name} replication":
    description => "Replication access from ${name}",
    type => 'host',
    database => 'replication',
    user => $user,
    address => "${ip}/32",
    auth_method => $auth_method,
    order => "050-${name}",
  }
}
