define twitch_postgresql::replication_target($address, $user, $auth_method) {
  postgresql::server::pg_hba_rule { "${name} replication":
    description => "Replication access from ${name}",
    type => 'host',
    database => 'replication',
    user => $user,
    address => $address,
    auth_method => $auth_method,
    order => "055-${name}",
  }
}
