define twitch_postgresql::user (
    $username = $title,
    $database_name,
    $database_env,
    $secret = undef,
    $ensure = 'present',
    $script_dir,
    $ss_team = $twitch_postgresql::ss_team
){
    twitch_sandstorm_agent::resource{ "postgres_user_${username}":
        key              => pick($secret, "${ss_team}/${database_name}/${database_env}/${username}"),
        exists_command   => "/usr/bin/sudo -u postgres ${script_dir}/postgres_user_exists.sh ${username}",
        create_command   => "/usr/bin/sudo -u postgres ${script_dir}/postgres_create_user.sh ${username} %q",
        in_sync_command  => "/usr/bin/sudo -u postgres ${script_dir}/postgres_in_sync.sh ${username} %q",
        update_command   => "/usr/bin/sudo -u postgres ${script_dir}/postgres_update_user.sh ${username} %q",
        destroy_command  => "/usr/bin/sudo -u postgres ${script_dir}/postgres_delete_user.sh ${username}",
        require          => [File['twitch-postgres-user_create'], File['twitch-postgres-user_delete'], File['twitch-postgres-user_update'], File['twitch-postgres-user_in_sync'], File['twitch-postgres-user_exists']],
        ensure           => $ensure,
    }
}
