require 'ipaddr'

Facter.add('proxy_needed') do
  setcode do
    proxy_needed = false
    # if we have no ec2 stuff defined
    if Facter.value('ec2_instance_id').nil?
      # and if we have a private IP address
      private_network = IPAddr.new('10.0.0.0/8')
      primary_ip = IPAddr.new(Facter.value('ipaddress_primary'))
      if private_network.include?(primary_ip)
        # we're baremetal on a private IP space
        proxy_needed = true
      end
    end
    proxy_needed
  end
end
